/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.skinsrestorer.shadow.aikar.commands.ACFBungeeListener;
import net.skinsrestorer.shadow.aikar.commands.ACFPatterns;
import net.skinsrestorer.shadow.aikar.commands.BaseCommand;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandCompletionContext;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandCompletions;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandContexts;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandExecutionContext;
import net.skinsrestorer.shadow.aikar.commands.BungeeCommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.BungeeConditionContext;
import net.skinsrestorer.shadow.aikar.commands.BungeeLocales;
import net.skinsrestorer.shadow.aikar.commands.BungeeMessageFormatter;
import net.skinsrestorer.shadow.aikar.commands.BungeeRootCommand;
import net.skinsrestorer.shadow.aikar.commands.CommandCompletionContext;
import net.skinsrestorer.shadow.aikar.commands.CommandCompletions;
import net.skinsrestorer.shadow.aikar.commands.CommandContexts;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.CommandParameter;
import net.skinsrestorer.shadow.aikar.commands.LogLevel;
import net.skinsrestorer.shadow.aikar.commands.MessageType;
import net.skinsrestorer.shadow.aikar.commands.RegisteredCommand;
import net.skinsrestorer.shadow.aikar.commands.RootCommand;
import net.skinsrestorer.shadow.aikar.commands.apachecommonslang.ApacheCommonsExceptionUtil;

public class BungeeCommandManager
extends CommandManager<CommandSender, BungeeCommandIssuer, ChatColor, BungeeMessageFormatter, BungeeCommandExecutionContext, BungeeConditionContext> {
    protected final Plugin plugin;
    protected Map<String, BungeeRootCommand> registeredCommands = new HashMap<String, BungeeRootCommand>();
    protected BungeeCommandContexts contexts;
    protected BungeeCommandCompletions completions;
    protected BungeeLocales locales;

    public BungeeCommandManager(Plugin plugin) {
        this.plugin = plugin;
        this.defaultFormatter = new BungeeMessageFormatter(ChatColor.RED, ChatColor.YELLOW, ChatColor.RED);
        this.formatters.put(MessageType.ERROR, this.defaultFormatter);
        this.formatters.put(MessageType.SYNTAX, new BungeeMessageFormatter(ChatColor.YELLOW, ChatColor.GREEN, ChatColor.WHITE));
        this.formatters.put(MessageType.INFO, new BungeeMessageFormatter(ChatColor.BLUE, ChatColor.DARK_GREEN, ChatColor.GREEN));
        this.formatters.put(MessageType.HELP, new BungeeMessageFormatter(ChatColor.AQUA, ChatColor.GREEN, ChatColor.YELLOW));
        this.getLocales();
        plugin.getProxy().getPluginManager().registerListener(plugin, (Listener)new ACFBungeeListener(this, plugin));
        plugin.getProxy().getScheduler().schedule(plugin, () -> ProxyServer.getInstance().getPlayers().forEach(this::readLocale), 5L, 5L, TimeUnit.SECONDS);
        this.registerDependency(plugin.getClass(), plugin);
        this.registerDependency(Plugin.class, plugin);
        this.registerDependency(PluginDescription.class, plugin.getDescription());
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public synchronized CommandContexts<BungeeCommandExecutionContext> getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = new BungeeCommandContexts(this);
        }
        return this.contexts;
    }

    @Override
    public synchronized CommandCompletions<BungeeCommandCompletionContext> getCommandCompletions() {
        if (this.completions == null) {
            this.completions = new BungeeCommandCompletions(this);
        }
        return this.completions;
    }

    @Override
    public BungeeLocales getLocales() {
        if (this.locales == null) {
            this.locales = new BungeeLocales(this);
            this.locales.loadLanguages();
        }
        return this.locales;
    }

    public void readLocale(ProxiedPlayer player) {
        if (!player.isConnected()) {
            return;
        }
        Locale locale = player.getLocale();
        if (locale != null) {
            this.setIssuerLocale(player, player.getLocale());
        }
    }

    @Override
    public void registerCommand(BaseCommand command) {
        command.onRegister(this);
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase(Locale.ENGLISH);
            BungeeRootCommand bungeeCommand = (BungeeRootCommand)entry.getValue();
            if (!bungeeCommand.isRegistered) {
                this.plugin.getProxy().getPluginManager().registerCommand(this.plugin, (Command)bungeeCommand);
            }
            bungeeCommand.isRegistered = true;
            this.registeredCommands.put(commandName, bungeeCommand);
        }
    }

    public void unregisterCommand(BaseCommand command) {
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase(Locale.ENGLISH);
            BungeeRootCommand bungeeCommand = (BungeeRootCommand)entry.getValue();
            bungeeCommand.getSubCommands().values().removeAll(command.subCommands.values());
            if (!bungeeCommand.getSubCommands().isEmpty() || !bungeeCommand.isRegistered) continue;
            this.unregisterCommand(bungeeCommand);
            bungeeCommand.isRegistered = false;
            this.registeredCommands.remove(commandName);
        }
    }

    public void unregisterCommand(BungeeRootCommand command) {
        this.plugin.getProxy().getPluginManager().unregisterCommand((Command)command);
    }

    public void unregisterCommands() {
        for (Map.Entry<String, BungeeRootCommand> entry : this.registeredCommands.entrySet()) {
            this.unregisterCommand(entry.getValue());
        }
    }

    @Override
    public boolean hasRegisteredCommands() {
        return !this.registeredCommands.isEmpty();
    }

    @Override
    public boolean isCommandIssuer(Class<?> aClass) {
        return CommandSender.class.isAssignableFrom(aClass);
    }

    @Override
    public BungeeCommandIssuer getCommandIssuer(Object issuer) {
        if (!(issuer instanceof CommandSender)) {
            throw new IllegalArgumentException(issuer.getClass().getName() + " is not a Command Issuer.");
        }
        return new BungeeCommandIssuer(this, (CommandSender)issuer);
    }

    @Override
    public RootCommand createRootCommand(String cmd) {
        return new BungeeRootCommand(this, cmd);
    }

    @Override
    public Collection<RootCommand> getRegisteredRootCommands() {
        return Collections.unmodifiableCollection(this.registeredCommands.values());
    }

    @Override
    public BungeeCommandExecutionContext createCommandContext(RegisteredCommand command, CommandParameter parameter, CommandIssuer sender, List<String> args, int i, Map<String, Object> passedArgs) {
        return new BungeeCommandExecutionContext(command, parameter, (BungeeCommandIssuer)sender, args, i, passedArgs);
    }

    @Override
    public CommandCompletionContext createCompletionContext(RegisteredCommand command, CommandIssuer sender, String input, String config, String[] args) {
        return new BungeeCommandCompletionContext(command, (BungeeCommandIssuer)sender, input, config, args);
    }

    @Override
    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new RegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    @Override
    public BungeeConditionContext createConditionContext(CommandIssuer issuer, String config) {
        return new BungeeConditionContext((BungeeCommandIssuer)issuer, config);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        Logger logger = this.plugin.getLogger();
        Level logLevel = level == LogLevel.INFO ? Level.INFO : Level.SEVERE;
        logger.log(logLevel, "[ACF] " + message);
        if (throwable != null) {
            for (String line : ACFPatterns.NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(throwable))) {
                logger.log(logLevel, "[ACF] " + line);
            }
        }
    }

    @Override
    public String getCommandPrefix(CommandIssuer issuer) {
        return issuer.isPlayer() ? "/" : "";
    }
}

